# -*- coding: utf-8 -*-
""" Activation Functions """

import math
import torch
import torch.nn.functional as F

# %% activation functions
def gelu(x):
    return (torch.erf(x/math.sqrt(2.0)) + 1.0) * x * 0.5


# ACT_FCN = {"gelu": gelu}
ACT_FCN = {"gelu": F.gelu}
